/*
 * Decompiled with CFR 0.152.
 */
package com.articles.web.rest;

import com.articles.repo.domain.Article;
import com.articles.service.ArticleService;
import com.articles.web.Validator;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/article"})
public class ArticleResource {
    private final Validator validator;
    private final ArticleService articleService;

    @PostMapping
    public void addArticle(@RequestBody Article article, @RequestHeader String string) {
        if (this.validator.validate(string)) {
            this.articleService.save(article);
        }
    }

    @GetMapping
    public List<Article> getAllArticles(@RequestHeader String string) {
        if (this.validator.validate(string)) {
            return this.articleService.getAll();
        }
        return new ArrayList<Article>();
    }

    public ArticleResource(Validator validator, ArticleService articleService) {
        this.validator = validator;
        this.articleService = articleService;
    }
}

