/*
 * Decompiled with CFR 0.152.
 */
package com.articles.service;

import com.articles.repo.CommentRepo;
import com.articles.repo.domain.Comment;
import com.articles.service.CommentService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TransactionalCommentService
implements CommentService {
    private final CommentRepo commentRepo;
    private final String EDITED_AUTHOR = "Beautiful pink unicorn";
    private final String EDITED_COMMENT = "Edited comment: Author really meant that article and other comments were beautiful. :)";

    public void save(Comment comment) {
        if (this.checkIfCommentIsBad(comment.getAuthor())) {
            comment.setAuthor("Beautiful pink unicorn");
        }
        if (this.checkIfCommentIsBad(comment.getComment())) {
            comment.setComment("Edited comment: Author really meant that article and other comments were beautiful. :)");
        }
        this.commentRepo.save((Object)comment);
    }

    private boolean checkIfCommentIsBad(String toCheck) {
        if (toCheck.contains("http://") || toCheck.contains("https://")) {
            return true;
        }
        if (toCheck.contains(" ass ") || toCheck.contains("Ass ")) {
            return true;
        }
        if (toCheck.contains(" fuck ") || toCheck.contains("Fuck ")) {
            return true;
        }
        return toCheck.contains(" asshole ") || toCheck.contains("Asshole ");
    }

    @PostConstruct
    public void init() {
        this.checkCommentsAmount();
    }

    public void checkCommentsAmount() {
        List all = this.commentRepo.findAll();
        ArrayList articleIds = new ArrayList(all.stream().map(c -> c.getArticle().getId()).collect(Collectors.toSet()));
        ArrayList<String> toReduceComments = new ArrayList<String>();
        for (String id : articleIds) {
            int size = all.stream().filter(c -> c.getArticle().getId().equals(id)).toList().size();
            if (size <= 20) continue;
            toReduceComments.add(id);
        }
        for (String toReduce : toReduceComments) {
            List<Comment> allBadCommentsByArticle = this.commentRepo.findAllByArticleId(toReduce).stream().filter(c -> c.getAuthor().equals("Beautiful pink unicorn") || c.getComment().equals("Edited comment: Author really meant that article and other comments were beautiful. :)")).toList();
            this.commentRepo.deleteAll(allBadCommentsByArticle);
        }
        for (String toReduce : toReduceComments) {
            if (this.commentRepo.findAllByArticleId(toReduce).stream().filter(c -> !c.getAuthor().equals("Beautiful pink unicorn") || !c.getComment().equals("Edited comment: Author really meant that article and other comments were beautiful. :)")).toList().size() <= 20) continue;
            List<Comment> allCommentsByArticle = this.commentRepo.findAllByArticleId(toReduce).stream().sorted(Comparator.comparing(Comment::getDate).reversed()).toList();
            this.commentRepo.deleteAll(allCommentsByArticle.subList(19, allCommentsByArticle.size()));
        }
    }

    public TransactionalCommentService(CommentRepo commentRepo) {
        this.commentRepo = commentRepo;
    }
}

